# Journal 日本語索引 実装メモ

最終更新: 2026-03-02  
対象: `openmwch/openmw`  
目的: ジャーナル Topics の索引を `A-Z` ではなく、日本語向け (`あ/か/さ/た/な/は/ま/や/ら/わ/英`) で動作させる。

---

## 1. 変更概要

- ジャーナル索引を **ロケール `ja` 判定** で日本語表示に切り替える実装を追加
- ランチャー言語設定「日本語」で `preferred locales` が反映されるよう修正
- 日本語先頭分類のため、読み辞書 `journal_japanese_yomi.tsv` を追加
- 配布/開発環境コピー対象へ辞書ファイルを追加

---

## 2. 変更ファイル一覧

### 新規

- `apps/openmw/mwgui/journalindex.hpp`
  - 日本語索引ID定数 (`あ/か/.../わ/英`) と順序定義
- `files/journal_japanese_yomi.tsv`
  - トピック名 -> 読み の辞書（DIAL由来）

### 既存修正

- `apps/openmw/mwgui/journalbooks.hpp`
  - 索引文字配列 `mTopicIndexChars` を保持
  - `createJapaneseJournalIndex()` 追加
- `apps/openmw/mwgui/journalbooks.cpp`
  - `ja` ロケール時に日本語索引ページを生成
  - ラテン/キリル/日本語で索引選択を切り替え
- `apps/openmw/mwgui/journalwindow.cpp`
  - コントローラ索引移動を固定26/30前提から可変索引長対応に変更
  - `ja` ロケール時の行数 (`6 + 5`) を反映
- `apps/openmw/mwgui/journalviewmodel.cpp`
  - 日本語索引ID (`あ/か/.../わ/英`) を解釈してトピック分類
  - かな先頭は直接分類、非かな先頭は `journal_japanese_yomi.tsv` の読みで補完
  - 辞書未ヒット時は `わ` バケットにフォールバック
- `apps/launcher/datafilespage.cpp`
  - ランチャー言語保存時に `Settings::general().mPreferredLocales` を同期更新
  - 例: 日本語 -> `ja,en`
- `files/CMakeLists.txt`
  - `journal_japanese_yomi.tsv` をリソースコピー対象に追加
- `CMakeLists.txt`
  - インストール対象に `journal_japanese_yomi.tsv` を追加
- `scripts/copy_resources_vs2022.bat`
  - 辞書を Debug/RelWithDebInfo/Release へコピー
- `scripts/copy_resources_vs2026.bat`
  - 辞書を Debug/RelWithDebInfo/Release へコピー

---

## 3. 重要仕様

## 3.1 有効条件

- 日本語索引は **`L10n::Manager` の優先ロケール先頭（`gmst`除外）が `ja` のとき有効**
- `encoding=utf8` 単体では切り替わらない（ランチャー修正で `preferred locales` も同時設定）

## 3.2 索引構成

- 11カテゴリ固定: `あ/か/さ/た/な/は/ま/や/ら/わ/英`
- UI配置は 2カラム想定（6 + 5）

## 3.3 分類ルール

1. 先頭有意文字を取得（記号・括弧・中点・全角空白などはスキップ）
2. 先頭が英字なら `英`
3. 先頭がかな（ひらがな/カタカナ）なら対応行へ
4. それ以外（漢字など）は辞書読み先頭で分類
5. 辞書が無い/不正なら `わ`

---

## 4. ビルド・生成（実施済み）

### OpenMW

- `cmake --build C:/YAMPT_Work/openmwch/openmw/MSVC2022_64 --config Release --target ALL_BUILD`
- 成功

### ESP

- `python esp_work/esp_tool.py --workspace C:/YAMPT_Work workflow build-jp-esp`
- 成功
- 生成物:
  - `output/tes3jp_Morrowind.esp`
  - `output/tes3jp_Tribunal.esp`
  - `output/tes3jp_Bloodmoon.esp`

---

## 5. 本家アップデート時の指針

## 5.1 競合しやすいポイント

- `apps/openmw/mwgui/journalbooks.cpp`
- `apps/openmw/mwgui/journalwindow.cpp`
- `apps/openmw/mwgui/journalviewmodel.cpp`
- `apps/launcher/datafilespage.cpp`

本家でジャーナルUIやランチャー言語処理が更新された場合、最優先で差分確認する。

## 5.2 追従時チェックリスト

1. `notifyOptions()` から索引ページが正しく生成されるか
2. コントローラ移動で索引末尾/列跨ぎが崩れないか
3. `visitTopicNamesStartingWith()` のシグネチャ変更有無
4. `L10n::Manager::getPreferredLocales()` 取得方法が変わっていないか
5. ランチャー保存で `preferred locales` が `settings.cfg` へ保存されるか

## 5.3 最低限の回帰確認

- ランチャー言語を日本語に変更して保存
- ゲーム再起動
- Journal -> Topics を開く
- 右索引が `あ/か/.../わ/英` になること
- 代表語（例: ちょっとした忠告）が想定行に入ること
- 英字トピックが `英` に入ること

---

## 6. 運用メモ（辞書）

- 辞書ファイル: `files/journal_japanese_yomi.tsv`
- 形式: `topicName<TAB>reading`
- `topicName` はジャーナル表示名と完全一致が必要
- 読みは先頭かな推奨（口語頭文字に合わせる）
- 新規トピック追加時は辞書追記を推奨

