#ifndef MWGUI_JOURNALINDEX_H
#define MWGUI_JOURNALINDEX_H

#include <array>
#include <algorithm>

#include <components/misc/utf8stream.hpp>

namespace MWGui::JournalIndex
{
    inline constexpr Utf8Stream::UnicodeChar sJapaneseA = 0x3042;      // あ
    inline constexpr Utf8Stream::UnicodeChar sJapaneseKa = 0x304B;     // か
    inline constexpr Utf8Stream::UnicodeChar sJapaneseSa = 0x3055;     // さ
    inline constexpr Utf8Stream::UnicodeChar sJapaneseTa = 0x305F;     // た
    inline constexpr Utf8Stream::UnicodeChar sJapaneseNa = 0x306A;     // な
    inline constexpr Utf8Stream::UnicodeChar sJapaneseHa = 0x306F;     // は
    inline constexpr Utf8Stream::UnicodeChar sJapaneseMa = 0x307E;     // ま
    inline constexpr Utf8Stream::UnicodeChar sJapaneseYa = 0x3084;     // や
    inline constexpr Utf8Stream::UnicodeChar sJapaneseRa = 0x3089;     // ら
    inline constexpr Utf8Stream::UnicodeChar sJapaneseWa = 0x308F;     // わ
    inline constexpr Utf8Stream::UnicodeChar sJapaneseEnglish = 0xE000; // Private-use marker for "英"

    inline constexpr std::array<Utf8Stream::UnicodeChar, 11> sJapaneseIndexOrder = { sJapaneseA, sJapaneseKa,
        sJapaneseSa, sJapaneseTa, sJapaneseNa, sJapaneseHa, sJapaneseMa, sJapaneseYa, sJapaneseRa, sJapaneseWa,
        sJapaneseEnglish };

    inline bool isJapaneseIndex(Utf8Stream::UnicodeChar character)
    {
        return std::find(sJapaneseIndexOrder.begin(), sJapaneseIndexOrder.end(), character) != sJapaneseIndexOrder.end();
    }
}

#endif // MWGUI_JOURNALINDEX_H
